/*
 *  include/linux/vzctl_quota.h
 *
 *  Copyright (C) 2005  SWsoft
 *  All rights reserved.
 *
 */

#ifndef __LINUX_VZCTL_QUOTA_H__
#define __LINUX_VZCTL_QUOTA_H__

/*
 * Quota management ioctl
 */

struct vz_quota_stat;
struct vzctl_quotactl {
	int cmd;
	unsigned int quota_id;
	struct vz_quota_stat *qstat;
	char *ve_root;
};

struct vzctl_quotaugidctl {
	int cmd;		/* subcommand */
	unsigned int quota_id;	/* quota id where it applies to */
	unsigned int ugid_index;/* for reading statistic. index of first
				    uid/gid record to read */
	unsigned int ugid_size;	/* size of ugid_buf array */
	void *addr; 		/* user-level buffer */
};

#define VZDQCTLTYPE '+'
#define VZCTL_QUOTA_CTL		_IOWR(VZDQCTLTYPE, 1,			\
					struct vzctl_quotactl)
#define VZCTL_QUOTA_NEW_CTL	_IOWR(VZDQCTLTYPE, 2,			\
					struct vzctl_quotactl)
#define VZCTL_QUOTA_UGID_CTL	_IOWR(VZDQCTLTYPE, 3,			\
					struct vzctl_quotaugidctl)

#endif /* __LINUX_VZCTL_QUOTA_H__ */
