/*
 *  include/ub/ub_dcache.h
 *
 *  Copyright (C) 2005  SWsoft
 *  All rights reserved.
 *
 */

#ifndef __UB_DCACHE_H_
#define __UB_DCACHE_H_

#include <ub/ub_decl.h>

/*
 * UB_DCACHESIZE accounting
 */

struct dentry_beancounter
{
	/*
	 *  d_inuse =
	 *         <number of external refs> +
	 *         <number of 'used' childs>
	 *
	 * d_inuse == -1 means that dentry is unused
	 * state change -1 => 0 causes charge
	 * state change 0 => -1 causes uncharge
	 */
	atomic_t d_inuse;
	/* charged size, including name length if name is not inline */
	unsigned long d_ubsize;
	struct user_beancounter *d_ub;
};

extern unsigned int inode_memusage(void);
extern unsigned int dentry_memusage(void);

struct dentry;

UB_DECLARE_FUNC(int, ub_dentry_alloc(struct dentry *d))
UB_DECLARE_FUNC(int, ub_dentry_charge(struct dentry *d))
UB_DECLARE_VOID_FUNC(ub_dentry_free(struct dentry *d))
UB_DECLARE_VOID_FUNC(ub_dentry_charge_nofail(struct dentry *d))
UB_DECLARE_VOID_FUNC(ub_dentry_uncharge(struct dentry *d))

#endif
