/*
 *  include/ub/ub_hash.h
 *
 *  Copyright (C) 2005  SWsoft
 *  All rights reserved.
 *
 */

#ifndef _LINUX_UBHASH_H
#define _LINUX_UBHASH_H

#ifdef __KERNEL__

#define UB_HASH_SIZE 256

struct ub_hash_slot {
	struct user_beancounter *ubh_beans;
};

extern struct ub_hash_slot ub_hash[];
extern spinlock_t ub_hash_lock;

#ifdef CONFIG_USER_RESOURCE

/*
 * Iterate over beancounters
 * @__slot  - hash slot
 * @__ubp - beancounter ptr
 * Can use break :)
 */
#define for_each_beancounter(__slot, __ubp)				\
	for (__slot = 0, __ubp = NULL; 					\
		__slot < UB_HASH_SIZE && __ubp == NULL; __slot++)	\
		 for (__ubp = ub_hash[__slot].ubh_beans; __ubp;		\
				 __ubp = __ubp->ub_next)

#endif /* CONFIG_USER_RESOURCE */
#endif /* __KERNEL__ */
#endif /* _LINUX_UBHASH_H */
