/*
 *  include/ub/ub_mem.h
 *
 *  Copyright (C) 2005  SWsoft
 *  All rights reserved.
 *
 */

#ifndef __UB_SLAB_H_
#define __UB_SLAB_H_

#include <linux/config.h>
#include <linux/kmem_slab.h>
#include <linux/vmalloc.h>
#include <linux/gfp.h>
#include <asm/pgtable.h>
#include <ub/beancounter.h>
#include <ub/ub_decl.h>

/*
 * UB_KMEMSIZE accounting
 * oom_killer related
 */

/*
 * Memory freeing statistics to make correct OOM decision
 */

struct oom_freeing_stat
{
	unsigned long oom_generation; /* current OOM gen */
	unsigned long freed;
	unsigned long swapped; /* page referrence counters removed */
	unsigned long written; /* IO started */
};

extern int oom_generation;
extern int oom_kill_counter;
extern spinlock_t oom_generation_lock;

#ifdef CONFIG_UBC_DEBUG_ITEMS 
#define CHARGE_ORDER(__o)		(1 << __o)
#define CHARGE_SIZE(__s)		1
#else
#define CHARGE_ORDER(__o)		(PAGE_SIZE << (__o))
#define CHARGE_SIZE(__s)		(__s)
#endif

#define page_ub(__page)	((__page)->bc.page_ub)

struct mm_struct;
struct page;

UB_DECLARE_FUNC(struct user_beancounter *, slab_ub(void *obj))
UB_DECLARE_FUNC(struct user_beancounter *, vmalloc_ub(void *obj))
UB_DECLARE_FUNC(struct user_beancounter *, mem_ub(void *obj))

UB_DECLARE_FUNC(int, ub_page_charge(struct page *page, int order, int mask))
UB_DECLARE_VOID_FUNC(ub_page_uncharge(struct page *page, int order))

UB_DECLARE_VOID_FUNC(ub_clear_oom(void))
UB_DECLARE_VOID_FUNC(ub_oomkill_task(struct mm_struct *mm, 
			struct user_beancounter *ub, long overdraft))
UB_DECLARE_FUNC(int, ub_slab_charge(void *objp, int flags))
UB_DECLARE_VOID_FUNC(ub_slab_uncharge(void *obj))

#ifdef CONFIG_USER_RESOURCE
/* Flags without __GFP_UBC must comply with vmalloc */
#define ub_vmalloc(size) __vmalloc(size, \
		GFP_KERNEL | __GFP_HIGHMEM | __GFP_UBC, PAGE_KERNEL)
#define ub_kmalloc(size, flags) kmalloc(size, ((flags) | __GFP_UBC))
extern struct user_beancounter *ub_select_worst(long *);
#else
#define ub_vmalloc(size) vmalloc(size)
#define ub_kmalloc(size, flags) kmalloc(size, flags)
static inline struct user_beancounter *ub_select_worst(long *over)
{
	*over = 0;
	return NULL;
}
#endif

#define slab_ubcs(cachep, slabp) ((struct user_beancounter **)\
		(slab_bufctl(slabp) + (cachep)->num))

#endif
