/*
 *  include/ub/ub_orphan.h
 *
 *  Copyright (C) 2005  SWsoft
 *  All rights reserved.
 *
 */

#ifndef __UB_ORPHAN_H_
#define __UB_ORPHAN_H_

#include "ub/beancounter.h"
#include "ub/ub_net.h"


extern int ub_too_many_orphans(struct sock *sk, int count);
static inline int tcp_too_many_orphans(struct sock *sk, int count)
{
#ifdef CONFIG_USER_RESOURCE
	if (ub_too_many_orphans(sk, count))
		return 1;
#endif
	return (atomic_read(&tcp_orphan_count) > sysctl_tcp_max_orphans ||
		(sk->sk_wmem_queued > SOCK_MIN_SNDBUF &&
		 atomic_read(&tcp_memory_allocated) > sysctl_tcp_mem[2]));
}

static inline atomic_t *tcp_get_orphan_count_ptr(struct sock *sk)
{
#ifdef CONFIG_USER_RESOURCE
	if (sock_has_ubc(sk))
		return &sock_bc(sk)->ub->ub_orphan_count;
#endif
	return &tcp_orphan_count;
}

static inline void tcp_inc_orphan_count(struct sock *sk)
{
	atomic_inc(tcp_get_orphan_count_ptr(sk));
}

static inline void tcp_dec_orphan_count(struct sock *sk)
{
	atomic_dec(tcp_get_orphan_count_ptr(sk));
}

static inline int tcp_get_orphan_count(struct sock *sk)
{
	return atomic_read(tcp_get_orphan_count_ptr(sk));
}

#endif
