/*
 *  include/ub/ub_vmpages.h
 *
 *  Copyright (C) 2005  SWsoft
 *  All rights reserved.
 *
 */

#ifndef __UB_PAGES_H_
#define __UB_PAGES_H_

#include <linux/linkage.h>
#include <linux/config.h>
#include <ub/beancounter.h>
#include <ub/ub_decl.h>

/*
 * UB_XXXPAGES
 */

/*
 * Check whether vma has private or copy-on-write mapping.
 * Should match checks in ub_protected_charge().
 */
#define VM_UB_PRIVATE(__flags, __file)					\
		( ((__flags) & VM_WRITE) ?				\
			(__file) == NULL || !((__flags) & VM_SHARED) :	\
			0						\
		)

#define UB_PAGE_WEIGHT_SHIFT 24
#define UB_PAGE_WEIGHT (1 << UB_PAGE_WEIGHT_SHIFT)

struct page_beancounter;

/* Mprotect charging result */
#define PRIVVM_ERROR		-1
#define PRIVVM_NO_CHARGE	0
#define PRIVVM_TO_PRIVATE	1
#define PRIVVM_TO_SHARED	2
 
#ifdef CONFIG_USER_RESOURCE
extern int ub_protected_charge(struct user_beancounter *ub, unsigned long size,
		unsigned long newflags,  struct vm_area_struct *vma);
#else
static inline int ub_protected_charge(struct user_beancounter *ub,
		unsigned long size, unsigned long flags,
		struct vm_area_struct *vma)
{
	return PRIVVM_NO_CHARGE;
}
#endif

UB_DECLARE_VOID_FUNC(ub_tmpfs_respages_inc(struct user_beancounter *ub, 
			unsigned long size))
UB_DECLARE_VOID_FUNC(ub_tmpfs_respages_dec(struct user_beancounter *ub,
			unsigned long size))
UB_DECLARE_FUNC(int, ub_shmpages_charge(struct user_beancounter *ub, long size))
UB_DECLARE_VOID_FUNC(ub_shmpages_uncharge(struct user_beancounter *ub, long sz))
UB_DECLARE_FUNC(int, ub_locked_mem_charge(struct user_beancounter *ub, long sz))
UB_DECLARE_VOID_FUNC(ub_locked_mem_uncharge(struct user_beancounter *ub, 
			long size))
UB_DECLARE_FUNC(int, ub_privvm_charge(struct user_beancounter *ub,
			unsigned long flags, struct file *file,
			unsigned long size))
UB_DECLARE_VOID_FUNC(ub_privvm_uncharge(struct user_beancounter *ub,
			unsigned long flags, struct file *file,
			unsigned long size))
UB_DECLARE_FUNC(int, ub_unused_privvm_inc(struct user_beancounter * ub, 
			long size, struct vm_area_struct *vma))
UB_DECLARE_VOID_FUNC(ub_unused_privvm_dec(struct user_beancounter *ub, long sz,
			struct vm_area_struct *vma))
UB_DECLARE_VOID_FUNC(__ub_unused_privvm_dec(struct user_beancounter *ub, long sz))
UB_DECLARE_FUNC(int, ub_memory_charge(struct user_beancounter * ub,
			unsigned long size, unsigned vm_flags,
			struct file *vm_file, int strict))
UB_DECLARE_VOID_FUNC(ub_memory_uncharge(struct user_beancounter * ub,
			unsigned long size, unsigned vm_flags,
			struct file *vm_file))
UB_DECLARE_FUNC(unsigned long, pages_in_vma_range(struct vm_area_struct *vma,
			unsigned long start, unsigned long end))
#define pages_in_vma(vma) \
		(pages_in_vma_range((vma), (vma)->vm_start, (vma)->vm_end))

extern void fastcall __ub_update_physpages(struct user_beancounter *ub);
extern void fastcall __ub_update_oomguarpages(struct user_beancounter *ub);
extern void fastcall __ub_update_privvm(struct user_beancounter *ub);

#ifdef CONFIG_USER_SWAP_ACCOUNTING
extern void ub_swapentry_inc(struct user_beancounter *ub);
extern void ub_swapentry_dec(struct user_beancounter *ub);
#endif

#ifdef CONFIG_USER_RSS_ACCOUNTING
#define PB_DECLARE_FUNC(ret, decl)	UB_DECLARE_FUNC(ret, decl)
#define PB_DECLARE_VOID_FUNC(decl)	UB_DECLARE_VOID_FUNC(decl)
#else
#define PB_DECLARE_FUNC(ret, decl)	static inline ret decl {return (ret)0;}
#define PB_DECLARE_VOID_FUNC(decl)	static inline void decl { }
#endif

PB_DECLARE_FUNC(int, pb_reserve_all(struct page_beancounter **pbc))
PB_DECLARE_FUNC(int, pb_alloc(struct page_beancounter **pbc))
PB_DECLARE_FUNC(int, pb_alloc_list(struct page_beancounter **pbc, int num,
			struct mm_struct *mm))
PB_DECLARE_FUNC(int, pb_add_ref(struct page *page, struct user_beancounter *ub,
			struct page_beancounter **pbc))
PB_DECLARE_VOID_FUNC(pb_free_list(struct page_beancounter **pb))
PB_DECLARE_VOID_FUNC(pb_free(struct page_beancounter **pb))
PB_DECLARE_VOID_FUNC(pb_add_list_ref(struct page *page, 
			struct user_beancounter *ub, 
			struct page_beancounter **pbc))
PB_DECLARE_VOID_FUNC(pb_remove_ref(struct page *page, 
			struct user_beancounter *ub))
PB_DECLARE_FUNC(struct user_beancounter *, pb_grab_page_ub(struct page *page))

#endif
